{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.11.98 - 22:34:15 $                                        =}
{========================================================================}
unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMSlider, StdCtrls, MMDIBCv, MMLevel, MMConect, MMDSPObj, MMUtils,
  MMDSWOut, MMWave, ExtCtrls, MMCstDlg, MMHook, MMDesign, MMPitch, MMRingBf;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    OpenDlg: TMMWaveOpenDialog;
    Timer1: TTimer;
    WFile: TMMWaveFile;
    WOut: TMMDSWaveOut;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    FileBtn: TButton;
    PlayBtn: TButton;
    StopBtn: TButton;
    Slider: TMMSlider;
    LoopCheck: TCheckBox;
    PitchSlider: TMMSlider;
    PitchLabel: TLabel;
    Label1: TLabel;
    procedure FileBtnClick(Sender: TObject);
    procedure PlayBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure WOutStart(Sender: TObject);
    procedure WOutStop(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SliderTrack(Sender: TObject);
    procedure SliderTrackEnd(Sender: TObject);
    procedure PitchSliderChange(Sender: TObject);
  private
    FSliding: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FileBtnClick(Sender: TObject);
begin
  with OpenDlg do
    if Execute then
    begin
      WFile.Wave.FileName := FileName;
      PlayBtn.Enabled := True;
    end;
end;


procedure TForm1.PlayBtnClick(Sender: TObject);
begin
  Slider.MaxValue := WFile.Wave.Length;
  WOut.Looping := LoopCheck.Checked;
  WOut.Start;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
  WOut.Stop;
end;

procedure TForm1.WOutStart(Sender: TObject);
begin
  PlayBtn.Enabled := False;
  StopBtn.Enabled := True;
  LoopCheck.Enabled := False;
  FileBtn.Enabled := False;
  PitchSlider.Enabled := True;
  Slider.Enabled := True;
  PitchSlider.Position := WOut.Frequency;
end;

procedure TForm1.WOutStop(Sender: TObject);
begin
  PlayBtn.Enabled := not False;
  StopBtn.Enabled := not True;
  LoopCheck.Enabled := not False;
  FileBtn.Enabled := not False;
  WOut.Close;
  Slider.Position := 0;
  Slider.Enabled := False;
  PitchSlider.Enabled := False;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  WOut.Close;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if Slider.Enabled and (dssPlay in WOut.State) and not FSliding then
    Slider.Position := WFile.Wave.Position;

  Label1.Caption := TimeToString(WOut.Position);
end;

procedure TForm1.SliderTrack(Sender: TObject);
begin
  FSliding := True;
end;

procedure TForm1.SliderTrackEnd(Sender: TObject);
begin
  if (dssPlay in WOut.State) then
  begin
     WOut.Pause;
     WFile.Wave.Position := Slider.Position;
     WOut.Reset;
     WOut.Restart;
  end;
  FSliding := False;
end;

procedure TForm1.PitchSliderChange(Sender: TObject);
begin
   WOut.Frequency := PitchSlider.Position;
end;

end.
